#!/usr/bin/perl -w

# Livestat 1.2, by Jason Weill (livestat@weill.org)
# Copyright (C) 2002 Jason Weill

# Livestat is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Livestat is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Livestat; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Enters in statistics from a new game.

# Arguments: none.
# Result: Finalizes the current tournament: removes the META refresh tags from 
#         the documents and changes round display to "Final".

use strict;

my ($dir, $nextname);

if (not -e "activetourney") {
  die "No tournament is active.  Use set-active to set a tournament.";
}

open ACTIVE, "activetourney" or die "Cannot open tournament file: $!";
chomp($dir = <ACTIVE>);
close ACTIVE or die "Cannot close tournament file: $!";

chdir($dir) or die "Cannot open directory $dir: $!";

while ($nextname = <*.html>) {
  @ARGV = ($nextname);
  $^I = ".bak"; # make backup copies of HTML files
  print "Finalizing file $nextname.\n";
  while (<>) {
    s/Standings after \d*? rounds/Final statistics/;
    s/Scoreboard after \d*? rounds/Final scoreboard/;
    s%<meta http-equiv=\"refresh\" content=\"\d*?\" />\w*$%%;
    print $_;
  }
}

print "Finalize complete.  Please republish files in $dir/.\n"
