#!/usr/bin/perl -w

# Livestat 1.2, by Jason Weill (livestat@weill.org)
# Copyright (C) 2001-02 Jason Weill

# Livestat is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Livestat is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Livestat; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Enters in statistics from a new game.

# Arguments: none.
# Result: Appends information about the game to the game definition file.

my %options;
my %teams;

if (not -e "activetourney") {
  die "No tournament is active.  Use set-active to set a tournament.";
}

open ACTIVE, "activetourney" or die "Cannot open tournament file: $!";
chomp($dir = <ACTIVE>);
close ACTIVE or die "Cannot close tournament file: $!";

chdir($dir) or die "Cannot open directory $dir: $!";

open CONFIG, "global.cfg" or die "Cannot open configuration file: $!";

$_ = "";
until (/BEGIN TEAM/) {
  $_ = <CONFIG>;
  chomp;
  #s/\#.*//g;
  if (/=/ and not /^\#/) {
    ($option, $setting) = split(/=/, $_);
    $options{$option} = $setting;
  }
}

until (/END TEAM/) {
  $_ = <CONFIG>;
  chomp;
  if (/=/ and not /^\#/) {
    ($option, $setting) = split(/=/, $_);
    $teams{$option} = $setting;
  }
}

close CONFIG or die "Cannot close config file: $!";

#print GAMES "# BEGIN GAME\n";
print "What round is this game? ";
chomp($round = <STDIN>);

#print GAMES "round=$response";
print "Valid teams are: \n";

my %reverseteams = reverse %teams;
my @lteams = sort(keys(%reverseteams));

foreach $team (@lteams) {
  print $reverseteams{$team} . "\t" . $team . "\n";
}

my @pteams = ("", "");
my @scores;

print "Enter two teams from the above list, by abbreviations (left column).\n";

while (not $teams{$pteams[0]}) {
  print " First team? ";
  chomp($pteams[0] = <STDIN>);
}

#print GAMES "team1=$pteams[0]\n";

while (not $teams{$pteams[1]}) {
  print "Second team? ";
  chomp($pteams[1] = <STDIN>);
}

for ($i = 0; $i < 2; $i++) {
  print $teams{$pteams[$i]} . "'s score: ";
  chomp($scores[$i] = <STDIN>);
}

open SCORES, ">>scores" or die "Can't open score file: $!";
print SCORES $round . "," . $pteams[0] . "," . $pteams[1] . "," . 
  $scores[0] . "," . $scores[1] . "\n";
close SCORES or die "Can't close score file: $!";

my $heard = 1;
if ($options{"timed"} eq "y") {
  print "Number of toss-ups heard? ";
  chomp($heard = <STDIN>);
}

#print GAMES "team2=$pteams[1]\n";

open GAMES, ">>indstats" or die "Cannot open stats file: $!";

my $pname = "";
my $power = 0;
my ($tossup, $neg5);
my $pheard;
for ($i = 0; $i < 2; $i++) {
  do {
    $opp = $pteams[($i + 1) % 2];
    $pln = $teams{$pteams[$i]};

    print "Enter a player name for $pln (or none when complete): ";
    chomp($pname = <STDIN>);
    
    if ($pname ne "") {
      if ($options{"timed"} eq "y") {
	print "Toss-ups heard by $pln - $pname (leave blank for all): ";
	chomp($pheard = <STDIN>);
      } else {
	print "Portion of round heard by $pln - $pname\n" . 
	  "(enter a decimal from 0 to 1, or leave blank for all): ";
	chomp($pheard = <STDIN>);
      }
      
      if ($pheard eq "") { $pheard = $heard };

      if ($options{"power"} eq "y") {
	print "Power toss-ups for $pln - $pname: ";
	chomp($power = <STDIN>);
      }
      
      print "      Toss-ups for $pln - $pname: ";
      chomp($tossup = <STDIN>);

      print "        Neg-5s for $pln - $pname: ";
      chomp($neg5 = <STDIN>);

      print GAMES "$round,$pteams[$i],$opp,$pname,$heard,$pheard,$power,"
	. "$tossup,$neg5\n";
    }
  } while ($pname ne "");
  print "Entry for $pln complete.\n";
}

close GAMES or die "Couldn't close output file: $!";
print "Game recorded successfully.\n";
