#!/usr/bin/perl -w

# Livestat 1.2, by Jason Weill (livestat@weill.org)
# Copyright (C) 2001-02 Jason Weill

# Livestat is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Livestat is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Livestat; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Creates a new tournament.

# Arguments: name of tournament
# Result: creates a new directory for use in the tournament, and sets 
#         the active tournament to this file.  Asks for configuration options.

use strict;

my $dir;
my $response;
my $abbrev;
my $configheader = "# Edit this file at your own risk.\n";

$dir = $ARGV[0];

$dir or die "Must specify target directory on command-line";

if (-e $dir) {
  print "Directory $dir already exists.  Continue anyway (y/n)? ";
  chomp ($response = <STDIN>);
  if (lc(substr($response, 0, 1)) ne "y") {
    die "User aborted"
  }
} else {
  mkdir($dir, 0777) or die "Cannot make directory $dir: $!";
}

open ACTIVE, ">activetourney" or 
  die "Cannot open tournament file: $!";

print ACTIVE $dir;

close ACTIVE or die "Cannot close tournament file: $!";

chdir ($dir) or die "Cannot change to directory $dir: $!";

open CONFIG, ">global.cfg" or die "Cannot write configuration file: $!";
print CONFIG $configheader;

print "What is the full name of this tournament? ";
$response = <STDIN>;
print CONFIG "name=$response";

print "Are power marks used (y/n)? ";
$response = <STDIN>;
if (lc(substr($response, 0, 1)) eq "y") {
  print CONFIG "power=y\n";
} else {
  print CONFIG "power=n\n";
}

print "Is this a timed tournament (y/n)? ";
$response = <STDIN>;
if (lc(substr($response, 0, 1)) eq "y") {
  print CONFIG "timed=y\n";
} else {
  print CONFIG "timed=n\n";
}

print CONFIG "\n# BEGIN TEAMS\n";
$response = "";
do {
  print "Enter team name (or none to exit): ";
  chomp($response = <STDIN>);
  if ($response ne "") {
    print "Enter a team abbreviation for $response: ";
    chomp($abbrev = <STDIN>);
    print CONFIG "$abbrev=$response\n";
  }
} while ($response ne "");
print CONFIG "# END TEAMS\n";

close CONFIG or die "Cannot close configuration file: $!";
