#!/usr/bin/perl -w

# Livestat 1.2, by Jason Weill (livestat@weill.org)
# Copyright (C) 2001-02 Jason Weill

# Livestat is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Livestat is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Livestat; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Uploads all files to the web server.

use Net::FTP;
use File::stat;
use File::Find;

$myusername = "your_user_name";
$mypassword = "your_password";
$servername = "your_server";
$targetdir = "your_base_www_directory"; # do NOT include a trailing slash!

if (not -e "activetourney") {
  die "No tournament is active.  Use set-active to set a tournament.";
}

open ACTIVE, "activetourney" or die "Cannot open tournament file: $!";
chomp($directory = <ACTIVE>);
close ACTIVE or die "Cannot close tournament file: $!";

find sub {
  return unless /\.html$/;
  push(@files, $File::Find::name);
}, "$directory/";

@files = sort(@files);

$ftp = Net::FTP->new($servername, Debug => 0);
$ftp->login($myusername, $mypassword) || die "Server login failed.";
$ftp->binary();

# first, upload the index.
$ftp->cwd($targetdir) || die "Error setting directory: $!";;

foreach $listing (@files) {
  print "Uploading file $listing.\n";
  $ftp->mkdir("$targetdir/$directory", 1); 
    # passes only the first time
  $ftp->cwd("$targetdir/$directory") ||
  die "Error setting directory: $!";
  $ftp->put($listing);
}
